@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.OptionBPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Option B configuration.
 * @property exportRouteTargets Route Targets to be applied for outgoing routes from CE.
 * @property importRouteTargets Route Targets to be applied for incoming routes into CE.
 */
public data class OptionBPropertiesArgs(
    public val exportRouteTargets: Output<List<String>>? = null,
    public val importRouteTargets: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.OptionBPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.OptionBPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.OptionBPropertiesArgs.builder()
            .exportRouteTargets(exportRouteTargets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .importRouteTargets(
                importRouteTargets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [OptionBPropertiesArgs].
 */
@PulumiTagMarker
public class OptionBPropertiesArgsBuilder internal constructor() {
    private var exportRouteTargets: Output<List<String>>? = null

    private var importRouteTargets: Output<List<String>>? = null

    /**
     * @param value Route Targets to be applied for outgoing routes from CE.
     */
    @JvmName("sywpxcqdfpstgsqd")
    public suspend fun exportRouteTargets(`value`: Output<List<String>>) {
        this.exportRouteTargets = value
    }

    @JvmName("onrxrcaotxoraxms")
    public suspend fun exportRouteTargets(vararg values: Output<String>) {
        this.exportRouteTargets = Output.all(values.asList())
    }

    /**
     * @param values Route Targets to be applied for outgoing routes from CE.
     */
    @JvmName("adlqfvxpilfbnqsw")
    public suspend fun exportRouteTargets(values: List<Output<String>>) {
        this.exportRouteTargets = Output.all(values)
    }

    /**
     * @param value Route Targets to be applied for incoming routes into CE.
     */
    @JvmName("qlawshthwyumfqkm")
    public suspend fun importRouteTargets(`value`: Output<List<String>>) {
        this.importRouteTargets = value
    }

    @JvmName("rwegpgcqmpjahwmu")
    public suspend fun importRouteTargets(vararg values: Output<String>) {
        this.importRouteTargets = Output.all(values.asList())
    }

    /**
     * @param values Route Targets to be applied for incoming routes into CE.
     */
    @JvmName("hujpmryfnfvqqcht")
    public suspend fun importRouteTargets(values: List<Output<String>>) {
        this.importRouteTargets = Output.all(values)
    }

    /**
     * @param value Route Targets to be applied for outgoing routes from CE.
     */
    @JvmName("klddhraivycnnuqb")
    public suspend fun exportRouteTargets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportRouteTargets = mapped
    }

    /**
     * @param values Route Targets to be applied for outgoing routes from CE.
     */
    @JvmName("ntmjwnsodgyoelwu")
    public suspend fun exportRouteTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exportRouteTargets = mapped
    }

    /**
     * @param value Route Targets to be applied for incoming routes into CE.
     */
    @JvmName("ayrjkufecyccmpbh")
    public suspend fun importRouteTargets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importRouteTargets = mapped
    }

    /**
     * @param values Route Targets to be applied for incoming routes into CE.
     */
    @JvmName("bivdtqpqjoiqoqkj")
    public suspend fun importRouteTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.importRouteTargets = mapped
    }

    internal fun build(): OptionBPropertiesArgs = OptionBPropertiesArgs(
        exportRouteTargets = exportRouteTargets,
        importRouteTargets = importRouteTargets,
    )
}
