@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.StaticRoutePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Static Route properties.
 * @property nextHop List of next hop IPv4 | IPv6 addresses.
 * @property prefix IPv4 | IPv6 Prefix.
 */
public data class StaticRoutePropertiesArgs(
    public val nextHop: Output<List<String>>,
    public val prefix: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.StaticRoutePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.StaticRoutePropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.StaticRoutePropertiesArgs.builder()
            .nextHop(nextHop.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefix(prefix.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticRoutePropertiesArgs].
 */
@PulumiTagMarker
public class StaticRoutePropertiesArgsBuilder internal constructor() {
    private var nextHop: Output<List<String>>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value List of next hop IPv4 | IPv6 addresses.
     */
    @JvmName("vpqqaxfitxlhatvp")
    public suspend fun nextHop(`value`: Output<List<String>>) {
        this.nextHop = value
    }

    @JvmName("fxrqgahdirfcflxv")
    public suspend fun nextHop(vararg values: Output<String>) {
        this.nextHop = Output.all(values.asList())
    }

    /**
     * @param values List of next hop IPv4 | IPv6 addresses.
     */
    @JvmName("fwoxmkoxmrymnboi")
    public suspend fun nextHop(values: List<Output<String>>) {
        this.nextHop = Output.all(values)
    }

    /**
     * @param value IPv4 | IPv6 Prefix.
     */
    @JvmName("wcxcscwcxsbmkavm")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value List of next hop IPv4 | IPv6 addresses.
     */
    @JvmName("vwernexjbuemfuhs")
    public suspend fun nextHop(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHop = mapped
    }

    /**
     * @param values List of next hop IPv4 | IPv6 addresses.
     */
    @JvmName("mmgrjmayxjbdjyxc")
    public suspend fun nextHop(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHop = mapped
    }

    /**
     * @param value IPv4 | IPv6 Prefix.
     */
    @JvmName("ojhqsgpqcqvukylo")
    public suspend fun prefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): StaticRoutePropertiesArgs = StaticRoutePropertiesArgs(
        nextHop = nextHop ?: throw PulumiNullFieldException("nextHop"),
        prefix = prefix ?: throw PulumiNullFieldException("prefix"),
    )
}
