@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * List of IPv4 and IPv6 route configurations.
 * @property ipv4Routes List of IPv4 Route prefixes.
 * @property ipv6Routes List of IPv6 Routes prefixes.
 */
public data class AggregateRouteConfigurationResponse(
    public val ipv4Routes: List<AggregateRouteResponse>? = null,
    public val ipv6Routes: List<AggregateRouteResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.AggregateRouteConfigurationResponse): AggregateRouteConfigurationResponse = AggregateRouteConfigurationResponse(
            ipv4Routes = javaType.ipv4Routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.AggregateRouteResponse.Companion.toKotlin(args0)
                })
            }),
            ipv6Routes = javaType.ipv6Routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.AggregateRouteResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
