@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Dynamic match configuration object.
 * @property ipGroups List of IP Groups.
 * @property portGroups List of the port groups.
 * @property vlanGroups List of vlan groups.
 */
public data class CommonDynamicMatchConfigurationResponse(
    public val ipGroups: List<IpGroupPropertiesResponse>? = null,
    public val portGroups: List<PortGroupPropertiesResponse>? = null,
    public val vlanGroups: List<VlanGroupPropertiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.CommonDynamicMatchConfigurationResponse): CommonDynamicMatchConfigurationResponse = CommonDynamicMatchConfigurationResponse(
            ipGroups = javaType.ipGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.IpGroupPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            portGroups = javaType.portGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.PortGroupPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            vlanGroups = javaType.vlanGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.VlanGroupPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
