@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The ExpressRoute circuit ID and the Auth Key are required for you to successfully deploy NFC service.
 * @property expressRouteAuthorizationKey Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
 * @property expressRouteCircuitId The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory attribute.
 */
public data class ExpressRouteConnectionInformationResponse(
    public val expressRouteAuthorizationKey: String,
    public val expressRouteCircuitId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.ExpressRouteConnectionInformationResponse): ExpressRouteConnectionInformationResponse = ExpressRouteConnectionInformationResponse(
            expressRouteAuthorizationKey = javaType.expressRouteAuthorizationKey(),
            expressRouteCircuitId = javaType.expressRouteCircuitId(),
        )
    }
}
