@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * option A properties object
 * @property bfdConfiguration BFD configuration properties
 * @property fabricASN Fabric ASN number. Example 65001
 * @property mtu MTU to use for option A peering.
 * @property peerASN Peer ASN number.Example : 28
 * @property primaryIpv4Prefix IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property primaryIpv6Prefix IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv4Prefix Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv6Prefix Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property vlanId Vlan identifier. Example : 501
 */
public data class ExternalNetworkPropertiesResponseOptionAProperties(
    public val bfdConfiguration: BfdConfigurationResponse? = null,
    public val fabricASN: Int,
    public val mtu: Int? = null,
    public val peerASN: Int,
    public val primaryIpv4Prefix: String? = null,
    public val primaryIpv6Prefix: String? = null,
    public val secondaryIpv4Prefix: String? = null,
    public val secondaryIpv6Prefix: String? = null,
    public val vlanId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.ExternalNetworkPropertiesResponseOptionAProperties): ExternalNetworkPropertiesResponseOptionAProperties =
            ExternalNetworkPropertiesResponseOptionAProperties(
                bfdConfiguration = javaType.bfdConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.BfdConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                fabricASN = javaType.fabricASN(),
                mtu = javaType.mtu().map({ args0 -> args0 }).orElse(null),
                peerASN = javaType.peerASN(),
                primaryIpv4Prefix = javaType.primaryIpv4Prefix().map({ args0 -> args0 }).orElse(null),
                primaryIpv6Prefix = javaType.primaryIpv6Prefix().map({ args0 -> args0 }).orElse(null),
                secondaryIpv4Prefix = javaType.secondaryIpv4Prefix().map({ args0 -> args0 }).orElse(null),
                secondaryIpv6Prefix = javaType.secondaryIpv6Prefix().map({ args0 -> args0 }).orElse(null),
                vlanId = javaType.vlanId(),
            )
    }
}
