@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Option B configuration.
 * @property exportRouteTargets Route Targets to be applied for outgoing routes from CE.
 * @property importRouteTargets Route Targets to be applied for incoming routes into CE.
 */
public data class FabricOptionBPropertiesResponse(
    public val exportRouteTargets: List<String>,
    public val importRouteTargets: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.FabricOptionBPropertiesResponse): FabricOptionBPropertiesResponse = FabricOptionBPropertiesResponse(
            exportRouteTargets = javaType.exportRouteTargets().map({ args0 -> args0 }),
            importRouteTargets = javaType.importRouteTargets().map({ args0 -> args0 }),
        )
    }
}
