@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the ExternalNetwork item.
 * @property administrativeState AdministrativeState of the externalNetwork. Example: Enabled | Disabled.
 * @property annotation Switch configuration description.
 * @property disabledOnResources List of resources the externalNetwork is disabled on. Can be either entire NetworkFabric or NetworkRack.
 * @property exportRoutePolicyId ARM resource ID of exportRoutePolicy.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property importRoutePolicyId ARM resource ID of importRoutePolicy.
 * @property name The name of the resource
 * @property networkToNetworkInterconnectId Gets the networkToNetworkInterconnectId of the resource.
 * @property optionAProperties option A properties object
 * @property optionBProperties option B properties object
 * @property peeringOption Peering option list.
 * @property provisioningState Gets the provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetExternalNetworkResult(
    public val administrativeState: String,
    public val `annotation`: String? = null,
    public val disabledOnResources: List<String>,
    public val exportRoutePolicyId: String? = null,
    public val id: String,
    public val importRoutePolicyId: String? = null,
    public val name: String,
    public val networkToNetworkInterconnectId: String,
    public val optionAProperties: ExternalNetworkPropertiesResponseOptionAProperties? = null,
    public val optionBProperties: OptionBPropertiesResponse? = null,
    public val peeringOption: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetExternalNetworkResult): GetExternalNetworkResult = GetExternalNetworkResult(
            administrativeState = javaType.administrativeState(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            disabledOnResources = javaType.disabledOnResources().map({ args0 -> args0 }),
            exportRoutePolicyId = javaType.exportRoutePolicyId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            importRoutePolicyId = javaType.importRoutePolicyId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkToNetworkInterconnectId = javaType.networkToNetworkInterconnectId(),
            optionAProperties = javaType.optionAProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ExternalNetworkPropertiesResponseOptionAProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
            optionBProperties = javaType.optionBProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.OptionBPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            peeringOption = javaType.peeringOption(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
