@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The IpExtendedCommunity resource definition.
 * @property action Action to be taken on the configuration. Example: Permit | Deny.
 * @property annotation Switch configuration description.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Gets the provisioning state of the resource.
 * @property routeTargets Route Target List.The expected formats are ASN(plain):NN >> example 4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example 10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in range of 0-4294967295.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIpExtendedCommunityResult(
    public val action: String,
    public val `annotation`: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val routeTargets: List<String>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetIpExtendedCommunityResult): GetIpExtendedCommunityResult = GetIpExtendedCommunityResult(
            action = javaType.action(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            routeTargets = javaType.routeTargets().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
