@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The L2IsolationDomain resource definition.
 * @property administrativeState state. Example: Enabled | Disabled. It indicates administrative state of the isolationDomain, whether it is enabled or disabled. If enabled, the configuration is applied on the devices. If disabled, the configuration is removed from the devices
 * @property annotation Switch configuration description.
 * @property disabledOnResources List of resources the L2 Isolation Domain is disabled on. Can be either entire NetworkFabric or NetworkRack.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property mtu maximum transmission unit. Default value is 1500.
 * @property name The name of the resource
 * @property networkFabricId Network Fabric ARM resource id.
 * @property provisioningState Gets the provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vlanId vlanId. Example: 501.
 */
public data class GetL2IsolationDomainResult(
    public val administrativeState: String,
    public val `annotation`: String? = null,
    public val disabledOnResources: List<String>,
    public val id: String,
    public val location: String,
    public val mtu: Int? = null,
    public val name: String,
    public val networkFabricId: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vlanId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetL2IsolationDomainResult): GetL2IsolationDomainResult = GetL2IsolationDomainResult(
            administrativeState = javaType.administrativeState(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            disabledOnResources = javaType.disabledOnResources().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            mtu = javaType.mtu().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkFabricId = javaType.networkFabricId(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vlanId = javaType.vlanId(),
        )
    }
}
