@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the Neighbor Group.
 * @property annotation Switch configuration description.
 * @property destination An array of destination IPv4 Addresses or IPv6 Addresses.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkTapIds List of NetworkTap IDs where neighbor group is associated.
 * @property networkTapRuleIds List of Network Tap Rule IDs where neighbor group is associated.
 * @property provisioningState The provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNeighborGroupResult(
    public val `annotation`: String? = null,
    public val destination: NeighborGroupDestinationResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val networkTapIds: List<String>,
    public val networkTapRuleIds: List<String>,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNeighborGroupResult): GetNeighborGroupResult = GetNeighborGroupResult(
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            destination = javaType.destination().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NeighborGroupDestinationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            networkTapIds = javaType.networkTapIds().map({ args0 -> args0 }),
            networkTapRuleIds = javaType.networkTapRuleIds().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
