@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The NetworkFabric resource definition.
 * @property annotation Switch configuration description.
 * @property fabricASN ASN of CE devices for CE/PE connectivity.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ipv4Prefix IPv4Prefix for Management Network. Example: 10.1.0.0/19.
 * @property ipv6Prefix IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
 * @property l2IsolationDomains List of L2IsolationDomain resource IDs under the Network Fabric.
 * @property l3IsolationDomains List of L3IsolationDomain resource IDs under the Network Fabric.
 * @property location The geo-location where the resource lives
 * @property managementNetworkConfiguration Configuration to be used to setup the management network.
 * @property name The name of the resource
 * @property networkFabricControllerId Azure resource ID for the NetworkFabricController the NetworkFabric belongs.
 * @property networkFabricSku Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The SKU determines whether it is a single / multi rack Network Fabric.
 * @property operationalState Gets the operational state of the resource.
 * @property provisioningState Gets the provisioning state of the resource.
 * @property rackCount Number of racks associated to Network Fabric.Possible values are from 2-8.
 * @property racks List of NetworkRack resource IDs under the Network Fabric. The number of racks allowed depends on the Network Fabric SKU.
 * @property routerId Router Id of CE to be used for MP-BGP between PE and CE
 * @property serverCountPerRack Number of servers.Possible values are from 1-16.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property terminalServerConfiguration Network and credentials configuration currently applied to terminal server.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNetworkFabricResult(
    public val `annotation`: String? = null,
    public val fabricASN: Int,
    public val id: String,
    public val ipv4Prefix: String? = null,
    public val ipv6Prefix: String? = null,
    public val l2IsolationDomains: List<String>,
    public val l3IsolationDomains: List<String>,
    public val location: String,
    public val managementNetworkConfiguration: ManagementNetworkConfigurationResponse,
    public val name: String,
    public val networkFabricControllerId: String,
    public val networkFabricSku: String,
    public val operationalState: String,
    public val provisioningState: String,
    public val rackCount: Int,
    public val racks: List<String>,
    public val routerId: String,
    public val serverCountPerRack: Int,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val terminalServerConfiguration: TerminalServerConfigurationResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkFabricResult): GetNetworkFabricResult = GetNetworkFabricResult(
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            fabricASN = javaType.fabricASN(),
            id = javaType.id(),
            ipv4Prefix = javaType.ipv4Prefix().map({ args0 -> args0 }).orElse(null),
            ipv6Prefix = javaType.ipv6Prefix().map({ args0 -> args0 }).orElse(null),
            l2IsolationDomains = javaType.l2IsolationDomains().map({ args0 -> args0 }),
            l3IsolationDomains = javaType.l3IsolationDomains().map({ args0 -> args0 }),
            location = javaType.location(),
            managementNetworkConfiguration = javaType.managementNetworkConfiguration().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ManagementNetworkConfigurationResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            networkFabricControllerId = javaType.networkFabricControllerId(),
            networkFabricSku = javaType.networkFabricSku(),
            operationalState = javaType.operationalState(),
            provisioningState = javaType.provisioningState(),
            rackCount = javaType.rackCount(),
            racks = javaType.racks().map({ args0 -> args0 }),
            routerId = javaType.routerId(),
            serverCountPerRack = javaType.serverCountPerRack(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            terminalServerConfiguration = javaType.terminalServerConfiguration().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.TerminalServerConfigurationResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
