@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Interface running status properties
 * @property administrativeState The interface administrative state.
 * @property connectedTo Connected to ARM resource or external interface
 * @property operationalStatus The interface operational status.
 * @property phyStatus The physical status.
 * @property transceiverStatus The interface transceiver type. Example: up or down
 */
public data class GetNetworkInterfaceStatusResult(
    public val administrativeState: String,
    public val connectedTo: String? = null,
    public val operationalStatus: String? = null,
    public val phyStatus: String? = null,
    public val transceiverStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkInterfaceStatusResult): GetNetworkInterfaceStatusResult = GetNetworkInterfaceStatusResult(
            administrativeState = javaType.administrativeState(),
            connectedTo = javaType.connectedTo().map({ args0 -> args0 }).orElse(null),
            operationalStatus = javaType.operationalStatus().map({ args0 -> args0 }).orElse(null),
            phyStatus = javaType.phyStatus().map({ args0 -> args0 }).orElse(null),
            transceiverStatus = javaType.transceiverStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
