@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Network Tap resource definition.
 * @property administrativeState Administrative state of the resource. Example -Enabled/Disabled
 * @property annotation Switch configuration description.
 * @property configurationState Gets the configurations state of the resource.
 * @property destinations List of destinations to send the filter traffic.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkPacketBrokerId ARM resource ID of the Network Packet Broker.
 * @property pollingType Polling type.
 * @property provisioningState Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on the status of Network Tap provisioning.
 * @property sourceTapRuleId Source Tap Rule Id. ARM Resource ID of the Network Tap Rule.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNetworkTapResult(
    public val administrativeState: String,
    public val `annotation`: String? = null,
    public val configurationState: String,
    public val destinations: List<NetworkTapPropertiesResponseDestinations>,
    public val id: String,
    public val location: String,
    public val name: String,
    public val networkPacketBrokerId: String,
    public val pollingType: String? = null,
    public val provisioningState: String,
    public val sourceTapRuleId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkTapResult): GetNetworkTapResult = GetNetworkTapResult(
            administrativeState = javaType.administrativeState(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            configurationState = javaType.configurationState(),
            destinations = javaType.destinations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NetworkTapPropertiesResponseDestinations.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            networkPacketBrokerId = javaType.networkPacketBrokerId(),
            pollingType = javaType.pollingType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sourceTapRuleId = javaType.sourceTapRuleId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
