@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action Action to be taken on the configuration. Example: Permit | Deny.
 * @property condition Specify prefix-list bounds.
 * @property networkPrefix Network Prefix specifying IPv4/IPv6 packets to be permitted or denied. Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126
 * @property sequenceNumber Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence number and continue down the list until a match is made. Once a match is made, the permit or deny statement is applied to that network and the rest of the list is ignored.
 * @property subnetMaskLength SubnetMaskLength gives the minimum NetworkPrefix length to be matched.Possible values for IPv4 are 1 - 32. Possible values of IPv6 are 1 - 128.
 */
public data class IpPrefixPropertiesResponseIpPrefixRules(
    public val action: String,
    public val condition: String? = null,
    public val networkPrefix: String,
    public val sequenceNumber: Double,
    public val subnetMaskLength: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.IpPrefixPropertiesResponseIpPrefixRules): IpPrefixPropertiesResponseIpPrefixRules = IpPrefixPropertiesResponseIpPrefixRules(
            action = javaType.action(),
            condition = javaType.condition().map({ args0 -> args0 }).orElse(null),
            networkPrefix = javaType.networkPrefix(),
            sequenceNumber = javaType.sequenceNumber(),
            subnetMaskLength = javaType.subnetMaskLength().map({ args0 -> args0 }).orElse(null),
        )
    }
}
