@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * layer3Configuration
 * @property exportRoutePolicyId exportRoutePolicyId
 * @property fabricASN ASN of CE devices for CE/PE connectivity.
 * @property importRoutePolicyId importRoutePolicyId
 * @property peerASN ASN of PE devices for CE/PE connectivity.Example : 28
 * @property primaryIpv4Prefix IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property primaryIpv6Prefix IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv4Prefix Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv6Prefix Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property vlanId VLAN for CE/PE Layer 3 connectivity.Example : 501
 */
public data class Layer3ConfigurationResponse(
    public val exportRoutePolicyId: String? = null,
    public val fabricASN: Int,
    public val importRoutePolicyId: String? = null,
    public val peerASN: Int? = null,
    public val primaryIpv4Prefix: String? = null,
    public val primaryIpv6Prefix: String? = null,
    public val secondaryIpv4Prefix: String? = null,
    public val secondaryIpv6Prefix: String? = null,
    public val vlanId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.Layer3ConfigurationResponse): Layer3ConfigurationResponse = Layer3ConfigurationResponse(
            exportRoutePolicyId = javaType.exportRoutePolicyId().map({ args0 -> args0 }).orElse(null),
            fabricASN = javaType.fabricASN(),
            importRoutePolicyId = javaType.importRoutePolicyId().map({ args0 -> args0 }).orElse(null),
            peerASN = javaType.peerASN().map({ args0 -> args0 }).orElse(null),
            primaryIpv4Prefix = javaType.primaryIpv4Prefix().map({ args0 -> args0 }).orElse(null),
            primaryIpv6Prefix = javaType.primaryIpv6Prefix().map({ args0 -> args0 }).orElse(null),
            secondaryIpv4Prefix = javaType.secondaryIpv4Prefix().map({ args0 -> args0 }).orElse(null),
            secondaryIpv6Prefix = javaType.secondaryIpv6Prefix().map({ args0 -> args0 }).orElse(null),
            vlanId = javaType.vlanId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
