@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed Resource Group configuration properties.
 * @property location Managed resource group location.
 * @property name The NFC service will be hosted in a Managed resource group.
 */
public data class ManagedResourceGroupConfigurationResponse(
    public val location: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.ManagedResourceGroupConfigurationResponse): ManagedResourceGroupConfigurationResponse = ManagedResourceGroupConfigurationResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
