@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An array of destination IPv4 Addresses or IPv6 Addresses.
 * @property ipv4Addresses Array of IPv4 Addresses.
 * @property ipv6Addresses Array of IPv6 Addresses.
 */
public data class NeighborGroupDestinationResponse(
    public val ipv4Addresses: List<String>? = null,
    public val ipv6Addresses: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.NeighborGroupDestinationResponse): NeighborGroupDestinationResponse = NeighborGroupDestinationResponse(
            ipv4Addresses = javaType.ipv4Addresses().map({ args0 -> args0 }),
            ipv6Addresses = javaType.ipv6Addresses().map({ args0 -> args0 }),
        )
    }
}
