@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Destination.
 * @property destinationId The destination Id. ARM Resource ID of either NNI or Internal Networks.
 * @property destinationTapRuleId ARM Resource ID of destination Tap Rule that contains match configurations.
 * @property destinationType Type of destination. Input can be IsolationDomain or Direct.
 * @property isolationDomainProperties Isolation Domain Properties.
 * @property name Destination name.
 */
public data class NetworkTapPropertiesResponseDestinations(
    public val destinationId: String,
    public val destinationTapRuleId: String? = null,
    public val destinationType: String,
    public val isolationDomainProperties: IsolationDomainPropertiesResponse? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.NetworkTapPropertiesResponseDestinations): NetworkTapPropertiesResponseDestinations = NetworkTapPropertiesResponseDestinations(
            destinationId = javaType.destinationId(),
            destinationTapRuleId = javaType.destinationTapRuleId().map({ args0 -> args0 }).orElse(null),
            destinationType = javaType.destinationType(),
            isolationDomainProperties = javaType.isolationDomainProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.IsolationDomainPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
        )
    }
}
