@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Action that need to performed.
 * @property destinationId Destination Id. The ARM resource Id may be either Network To Network Interconnect or NeighborGroup.
 * @property isTimestampEnabled The parameter to enable or disable the timestamp.
 * @property matchConfigurationName The name of the match configuration. This is used when Goto type is provided. If Goto type is selected and no match configuration name is provided. It goes to next configuration.
 * @property truncate Truncate. 0 indicates do not truncate.
 * @property type Type of actions that can be performed.
 */
public data class NetworkTapRuleActionResponse(
    public val destinationId: String? = null,
    public val isTimestampEnabled: String? = null,
    public val matchConfigurationName: String? = null,
    public val truncate: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.NetworkTapRuleActionResponse): NetworkTapRuleActionResponse = NetworkTapRuleActionResponse(
            destinationId = javaType.destinationId().map({ args0 -> args0 }).orElse(null),
            isTimestampEnabled = javaType.isTimestampEnabled().map({ args0 -> args0 }).orElse(null),
            matchConfigurationName = javaType.matchConfigurationName().map({ args0 -> args0 }).orElse(null),
            truncate = javaType.truncate().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
