@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the match condition that is supported to filter the traffic.
 * @property encapsulationType Encapsulation Type that needs to be matched.
 * @property ipCondition IP condition that needs to be matched.
 * @property portCondition Defines the port condition that needs to be matched.
 * @property protocolTypes List of the protocols that need to be matched.
 * @property vlanMatchCondition Vlan match condition that needs to be matched.
 */
public data class NetworkTapRuleMatchConditionResponse(
    public val encapsulationType: String? = null,
    public val ipCondition: IpMatchConditionResponse? = null,
    public val portCondition: PortConditionResponse? = null,
    public val protocolTypes: List<String>? = null,
    public val vlanMatchCondition: VlanMatchConditionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.NetworkTapRuleMatchConditionResponse): NetworkTapRuleMatchConditionResponse = NetworkTapRuleMatchConditionResponse(
            encapsulationType = javaType.encapsulationType().map({ args0 -> args0 }).orElse(null),
            ipCondition = javaType.ipCondition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.IpMatchConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            portCondition = javaType.portCondition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.PortConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protocolTypes = javaType.protocolTypes().map({ args0 -> args0 }),
            vlanMatchCondition = javaType.vlanMatchCondition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.VlanMatchConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
