@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Port condition that needs to be matched.
 * @property layer4Protocol Layer4 protocol type that needs to be matched.
 * @property portGroupNames List of the port Group Names that need to be matched.
 * @property portType Port type that needs to be matched.
 * @property ports List of the Ports that need to be matched.
 */
public data class PortConditionResponse(
    public val layer4Protocol: String,
    public val portGroupNames: List<String>? = null,
    public val portType: String? = null,
    public val ports: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.PortConditionResponse): PortConditionResponse = PortConditionResponse(
            layer4Protocol = javaType.layer4Protocol(),
            portGroupNames = javaType.portGroupNames().map({ args0 -> args0 }),
            portType = javaType.portType().map({ args0 -> args0 }).orElse(null),
            ports = javaType.ports().map({ args0 -> args0 }),
        )
    }
}
