@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Route policy action properties.
 * @property actionType action. Example: Permit | Deny.
 * @property ipCommunityProperties IP Community Properties.
 * @property ipExtendedCommunityProperties IP Extended Community Properties.
 * @property localPreference localPreference of the route policy.
 */
public data class StatementActionPropertiesResponse(
    public val actionType: String,
    public val ipCommunityProperties: ActionIpCommunityPropertiesResponse? = null,
    public val ipExtendedCommunityProperties: ActionIpExtendedCommunityPropertiesResponse? = null,
    public val localPreference: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.StatementActionPropertiesResponse): StatementActionPropertiesResponse = StatementActionPropertiesResponse(
            actionType = javaType.actionType(),
            ipCommunityProperties = javaType.ipCommunityProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ActionIpCommunityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipExtendedCommunityProperties = javaType.ipExtendedCommunityProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ActionIpExtendedCommunityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            localPreference = javaType.localPreference().map({ args0 -> args0 }).orElse(null),
        )
    }
}
