@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network and credentials configuration currently applied to terminal server.
 * @property networkDeviceId ARM Resource ID used for the NetworkDevice.
 * @property password Password for the terminal server connection.
 * @property primaryIpv4Prefix IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property primaryIpv6Prefix IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv4Prefix Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv6Prefix Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property serialNumber Serial Number of Terminal server.
 * @property username Username for the terminal server connection.
 */
public data class TerminalServerConfigurationResponse(
    public val networkDeviceId: String,
    public val password: String,
    public val primaryIpv4Prefix: String,
    public val primaryIpv6Prefix: String? = null,
    public val secondaryIpv4Prefix: String,
    public val secondaryIpv6Prefix: String? = null,
    public val serialNumber: String? = null,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.TerminalServerConfigurationResponse): TerminalServerConfigurationResponse = TerminalServerConfigurationResponse(
            networkDeviceId = javaType.networkDeviceId(),
            password = javaType.password(),
            primaryIpv4Prefix = javaType.primaryIpv4Prefix(),
            primaryIpv6Prefix = javaType.primaryIpv6Prefix().map({ args0 -> args0 }).orElse(null),
            secondaryIpv4Prefix = javaType.secondaryIpv4Prefix(),
            secondaryIpv6Prefix = javaType.secondaryIpv6Prefix().map({ args0 -> args0 }).orElse(null),
            serialNumber = javaType.serialNumber().map({ args0 -> args0 }).orElse(null),
            username = javaType.username(),
        )
    }
}
