@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration for infrastructure vpn.
 * @property administrativeState Indicates configuration state. Example: Enabled | Disabled.
 * @property networkToNetworkInterconnectId Gets the networkToNetworkInterconnectId of the resource.
 * @property optionAProperties option A properties
 * @property optionBProperties option B properties
 * @property peeringOption Peering option list.
 */
public data class VpnConfigurationPropertiesResponse(
    public val administrativeState: String,
    public val networkToNetworkInterconnectId: String,
    public val optionAProperties: OptionAPropertiesResponse? = null,
    public val optionBProperties: FabricOptionBPropertiesResponse? = null,
    public val peeringOption: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.VpnConfigurationPropertiesResponse): VpnConfigurationPropertiesResponse = VpnConfigurationPropertiesResponse(
            administrativeState = javaType.administrativeState(),
            networkToNetworkInterconnectId = javaType.networkToNetworkInterconnectId(),
            optionAProperties = javaType.optionAProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.OptionAPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            optionBProperties = javaType.optionBProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.FabricOptionBPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            peeringOption = javaType.peeringOption(),
        )
    }
}
