@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin

import com.pulumi.azurenative.managedservices.ManagedservicesFunctions.getRegistrationAssignmentPlain
import com.pulumi.azurenative.managedservices.ManagedservicesFunctions.getRegistrationDefinitionPlain
import com.pulumi.azurenative.managedservices.kotlin.inputs.GetRegistrationAssignmentPlainArgs
import com.pulumi.azurenative.managedservices.kotlin.inputs.GetRegistrationAssignmentPlainArgsBuilder
import com.pulumi.azurenative.managedservices.kotlin.inputs.GetRegistrationDefinitionPlainArgs
import com.pulumi.azurenative.managedservices.kotlin.inputs.GetRegistrationDefinitionPlainArgsBuilder
import com.pulumi.azurenative.managedservices.kotlin.outputs.GetRegistrationAssignmentResult
import com.pulumi.azurenative.managedservices.kotlin.outputs.GetRegistrationDefinitionResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.managedservices.kotlin.outputs.GetRegistrationAssignmentResult.Companion.toKotlin as getRegistrationAssignmentResultToKotlin
import com.pulumi.azurenative.managedservices.kotlin.outputs.GetRegistrationDefinitionResult.Companion.toKotlin as getRegistrationDefinitionResultToKotlin

public object ManagedservicesFunctions {
    /**
     * Gets the details of the specified registration assignment.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return The registration assignment.
     */
    public suspend fun getRegistrationAssignment(argument: GetRegistrationAssignmentPlainArgs): GetRegistrationAssignmentResult =
        getRegistrationAssignmentResultToKotlin(getRegistrationAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getRegistrationAssignment].
     * @param expandRegistrationDefinition The flag indicating whether to return the registration definition details along with the registration assignment details.
     * @param registrationAssignmentId The GUID of the registration assignment.
     * @param scope The scope of the resource.
     * @return The registration assignment.
     */
    public suspend fun getRegistrationAssignment(
        expandRegistrationDefinition: Boolean? = null,
        registrationAssignmentId: String,
        scope: String,
    ): GetRegistrationAssignmentResult {
        val argument = GetRegistrationAssignmentPlainArgs(
            expandRegistrationDefinition = expandRegistrationDefinition,
            registrationAssignmentId = registrationAssignmentId,
            scope = scope,
        )
        return getRegistrationAssignmentResultToKotlin(getRegistrationAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistrationAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managedservices&#46;kotlin&#46;inputs&#46;GetRegistrationAssignmentPlainArgs].
     * @return The registration assignment.
     */
    public suspend fun getRegistrationAssignment(argument: suspend GetRegistrationAssignmentPlainArgsBuilder.() -> Unit): GetRegistrationAssignmentResult {
        val builder = GetRegistrationAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistrationAssignmentResultToKotlin(getRegistrationAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the registration definition details.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return The registration definition.
     */
    public suspend fun getRegistrationDefinition(argument: GetRegistrationDefinitionPlainArgs): GetRegistrationDefinitionResult =
        getRegistrationDefinitionResultToKotlin(getRegistrationDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getRegistrationDefinition].
     * @param registrationDefinitionId The GUID of the registration definition.
     * @param scope The scope of the resource.
     * @return The registration definition.
     */
    public suspend fun getRegistrationDefinition(registrationDefinitionId: String, scope: String): GetRegistrationDefinitionResult {
        val argument = GetRegistrationDefinitionPlainArgs(
            registrationDefinitionId = registrationDefinitionId,
            scope = scope,
        )
        return getRegistrationDefinitionResultToKotlin(getRegistrationDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistrationDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managedservices&#46;kotlin&#46;inputs&#46;GetRegistrationDefinitionPlainArgs].
     * @return The registration definition.
     */
    public suspend fun getRegistrationDefinition(argument: suspend GetRegistrationDefinitionPlainArgsBuilder.() -> Unit): GetRegistrationDefinitionResult {
        val builder = GetRegistrationDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistrationDefinitionResultToKotlin(getRegistrationDefinitionPlain(builtArgument.toJava()).await())
    }
}
