@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin

import com.pulumi.azurenative.managedservices.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.managedservices.kotlin.outputs.RegistrationDefinitionPropertiesResponse
import com.pulumi.azurenative.managedservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.managedservices.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.managedservices.kotlin.outputs.RegistrationDefinitionPropertiesResponse.Companion.toKotlin as registrationDefinitionPropertiesResponseToKotlin
import com.pulumi.azurenative.managedservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistrationDefinition].
 */
@PulumiTagMarker
public class RegistrationDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistrationDefinitionArgs = RegistrationDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistrationDefinitionArgsBuilder.() -> Unit) {
        val builder = RegistrationDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistrationDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.managedservices.RegistrationDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistrationDefinition(builtJavaResource)
    }
}

/**
 * The registration definition.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * ## Example Usage
 * ### Put Registration Definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registrationDefinition = new AzureNative.ManagedServices.RegistrationDefinition("registrationDefinition", new()
 *     {
 *         Plan = new AzureNative.ManagedServices.Inputs.PlanArgs
 *         {
 *             Name = "addesai-plan",
 *             Product = "test",
 *             Publisher = "marketplace-test",
 *             Version = "1.0.0",
 *         },
 *         Properties = new AzureNative.ManagedServices.Inputs.RegistrationDefinitionPropertiesArgs
 *         {
 *             Authorizations = new[]
 *             {
 *                 new AzureNative.ManagedServices.Inputs.AuthorizationArgs
 *                 {
 *                     PrincipalId = "f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc",
 *                     PrincipalIdDisplayName = "Support User",
 *                     RoleDefinitionId = "acdd72a7-3385-48ef-bd42-f606fba81ae7",
 *                 },
 *                 new AzureNative.ManagedServices.Inputs.AuthorizationArgs
 *                 {
 *                     DelegatedRoleDefinitionIds = new[]
 *                     {
 *                         "b24988ac-6180-42a0-ab88-20f7382dd24c",
 *                     },
 *                     PrincipalId = "f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc",
 *                     PrincipalIdDisplayName = "User Access Administrator",
 *                     RoleDefinitionId = "18d7d88d-d35e-4fb5-a5c3-7773c20a72d9",
 *                 },
 *             },
 *             Description = "Tes1t",
 *             EligibleAuthorizations = new[]
 *             {
 *                 new AzureNative.ManagedServices.Inputs.EligibleAuthorizationArgs
 *                 {
 *                     JustInTimeAccessPolicy = new AzureNative.ManagedServices.Inputs.JustInTimeAccessPolicyArgs
 *                     {
 *                         ManagedByTenantApprovers = new[]
 *                         {
 *                             new AzureNative.ManagedServices.Inputs.EligibleApproverArgs
 *                             {
 *                                 PrincipalId = "d9b22cd6-6407-43cc-8c60-07c56df0b51a",
 *                                 PrincipalIdDisplayName = "Approver Group",
 *                             },
 *                         },
 *                         MaximumActivationDuration = "PT8H",
 *                         MultiFactorAuthProvider = AzureNative.ManagedServices.MultiFactorAuthProvider.Azure,
 *                     },
 *                     PrincipalId = "3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2",
 *                     PrincipalIdDisplayName = "Support User",
 *                     RoleDefinitionId = "ae349356-3a1b-4a5e-921d-050484c6347e",
 *                 },
 *             },
 *             ManagedByTenantId = "83abe5cd-bcc3-441a-bd86-e6a75360cecc",
 *             RegistrationDefinitionName = "DefinitionName",
 *         },
 *         RegistrationDefinitionId = "26c128c2-fefa-4340-9bb1-6e081c90ada2",
 *         Scope = "subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managedservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managedservices.NewRegistrationDefinition(ctx, "registrationDefinition", &managedservices.RegistrationDefinitionArgs{
 * 			Plan: &managedservices.PlanArgs{
 * 				Name:      pulumi.String("addesai-plan"),
 * 				Product:   pulumi.String("test"),
 * 				Publisher: pulumi.String("marketplace-test"),
 * 				Version:   pulumi.String("1.0.0"),
 * 			},
 * 			Properties: &managedservices.RegistrationDefinitionPropertiesArgs{
 * 				Authorizations: managedservices.AuthorizationArray{
 * 					&managedservices.AuthorizationArgs{
 * 						PrincipalId:            pulumi.String("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
 * 						PrincipalIdDisplayName: pulumi.String("Support User"),
 * 						RoleDefinitionId:       pulumi.String("acdd72a7-3385-48ef-bd42-f606fba81ae7"),
 * 					},
 * 					&managedservices.AuthorizationArgs{
 * 						DelegatedRoleDefinitionIds: pulumi.StringArray{
 * 							pulumi.String("b24988ac-6180-42a0-ab88-20f7382dd24c"),
 * 						},
 * 						PrincipalId:            pulumi.String("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
 * 						PrincipalIdDisplayName: pulumi.String("User Access Administrator"),
 * 						RoleDefinitionId:       pulumi.String("18d7d88d-d35e-4fb5-a5c3-7773c20a72d9"),
 * 					},
 * 				},
 * 				Description: pulumi.String("Tes1t"),
 * 				EligibleAuthorizations: managedservices.EligibleAuthorizationArray{
 * 					&managedservices.EligibleAuthorizationArgs{
 * 						JustInTimeAccessPolicy: &managedservices.JustInTimeAccessPolicyArgs{
 * 							ManagedByTenantApprovers: managedservices.EligibleApproverArray{
 * 								&managedservices.EligibleApproverArgs{
 * 									PrincipalId:            pulumi.String("d9b22cd6-6407-43cc-8c60-07c56df0b51a"),
 * 									PrincipalIdDisplayName: pulumi.String("Approver Group"),
 * 								},
 * 							},
 * 							MaximumActivationDuration: pulumi.String("PT8H"),
 * 							MultiFactorAuthProvider:   pulumi.String(managedservices.MultiFactorAuthProviderAzure),
 * 						},
 * 						PrincipalId:            pulumi.String("3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2"),
 * 						PrincipalIdDisplayName: pulumi.String("Support User"),
 * 						RoleDefinitionId:       pulumi.String("ae349356-3a1b-4a5e-921d-050484c6347e"),
 * 					},
 * 				},
 * 				ManagedByTenantId:          pulumi.String("83abe5cd-bcc3-441a-bd86-e6a75360cecc"),
 * 				RegistrationDefinitionName: pulumi.String("DefinitionName"),
 * 			},
 * 			RegistrationDefinitionId: pulumi.String("26c128c2-fefa-4340-9bb1-6e081c90ada2"),
 * 			Scope:                    pulumi.String("subscription/0afefe50-734e-4610-8a82-a144ahf49dea"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managedservices.RegistrationDefinition;
 * import com.pulumi.azurenative.managedservices.RegistrationDefinitionArgs;
 * import com.pulumi.azurenative.managedservices.inputs.PlanArgs;
 * import com.pulumi.azurenative.managedservices.inputs.RegistrationDefinitionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registrationDefinition = new RegistrationDefinition("registrationDefinition", RegistrationDefinitionArgs.builder()
 *             .plan(PlanArgs.builder()
 *                 .name("addesai-plan")
 *                 .product("test")
 *                 .publisher("marketplace-test")
 *                 .version("1.0.0")
 *                 .build())
 *             .properties(RegistrationDefinitionPropertiesArgs.builder()
 *                 .authorizations(
 *                     AuthorizationArgs.builder()
 *                         .principalId("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc")
 *                         .principalIdDisplayName("Support User")
 *                         .roleDefinitionId("acdd72a7-3385-48ef-bd42-f606fba81ae7")
 *                         .build(),
 *                     AuthorizationArgs.builder()
 *                         .delegatedRoleDefinitionIds("b24988ac-6180-42a0-ab88-20f7382dd24c")
 *                         .principalId("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc")
 *                         .principalIdDisplayName("User Access Administrator")
 *                         .roleDefinitionId("18d7d88d-d35e-4fb5-a5c3-7773c20a72d9")
 *                         .build())
 *                 .description("Tes1t")
 *                 .eligibleAuthorizations(EligibleAuthorizationArgs.builder()
 *                     .justInTimeAccessPolicy(JustInTimeAccessPolicyArgs.builder()
 *                         .managedByTenantApprovers(EligibleApproverArgs.builder()
 *                             .principalId("d9b22cd6-6407-43cc-8c60-07c56df0b51a")
 *                             .principalIdDisplayName("Approver Group")
 *                             .build())
 *                         .maximumActivationDuration("PT8H")
 *                         .multiFactorAuthProvider("Azure")
 *                         .build())
 *                     .principalId("3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2")
 *                     .principalIdDisplayName("Support User")
 *                     .roleDefinitionId("ae349356-3a1b-4a5e-921d-050484c6347e")
 *                     .build())
 *                 .managedByTenantId("83abe5cd-bcc3-441a-bd86-e6a75360cecc")
 *                 .registrationDefinitionName("DefinitionName")
 *                 .build())
 *             .registrationDefinitionId("26c128c2-fefa-4340-9bb1-6e081c90ada2")
 *             .scope("subscription/0afefe50-734e-4610-8a82-a144ahf49dea")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managedservices:RegistrationDefinition 26c128c2-fefa-4340-9bb1-6e081c90ada2 /{scope}/providers/Microsoft.ManagedServices/registrationDefinitions/{registrationDefinitionId}
 * ```
 */
public class RegistrationDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.managedservices.RegistrationDefinition,
) : KotlinCustomResource(javaResource, RegistrationDefinitionMapper) {
    /**
     * The name of the registration definition.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The details for the Managed Services offer’s plan in Azure Marketplace.
     */
    public val plan: Output<PlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The properties of a registration definition.
     */
    public val properties: Output<RegistrationDefinitionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                registrationDefinitionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The metadata for the registration assignment resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the Azure resource (Microsoft.ManagedServices/registrationDefinitions).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistrationDefinitionMapper : ResourceMapper<RegistrationDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managedservices.RegistrationDefinition::class == javaResource::class

    override fun map(javaResource: Resource): RegistrationDefinition =
        RegistrationDefinition(
            javaResource as
                com.pulumi.azurenative.managedservices.RegistrationDefinition,
        )
}

/**
 * @see [RegistrationDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistrationDefinition].
 */
public suspend fun registrationDefinition(
    name: String,
    block: suspend RegistrationDefinitionResourceBuilder.() -> Unit,
): RegistrationDefinition {
    val builder = RegistrationDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistrationDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registrationDefinition(name: String): RegistrationDefinition {
    val builder = RegistrationDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
