@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.AuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Azure Active Directory principal identifier and Azure built-in role that describes the access the principal will receive on the delegated resource in the managed tenant.
 * @property delegatedRoleDefinitionIds The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role. It is the list of role definition ids which define all the permissions that the user in the authorization can assign to other principals.
 * @property principalId The identifier of the Azure Active Directory principal.
 * @property principalIdDisplayName The display name of the Azure Active Directory principal.
 * @property roleDefinitionId The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
 */
public data class AuthorizationArgs(
    public val delegatedRoleDefinitionIds: Output<List<String>>? = null,
    public val principalId: Output<String>,
    public val principalIdDisplayName: Output<String>? = null,
    public val roleDefinitionId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.AuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.managedservices.inputs.AuthorizationArgs =
        com.pulumi.azurenative.managedservices.inputs.AuthorizationArgs.builder()
            .delegatedRoleDefinitionIds(
                delegatedRoleDefinitionIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .principalIdDisplayName(principalIdDisplayName?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationArgs].
 */
@PulumiTagMarker
public class AuthorizationArgsBuilder internal constructor() {
    private var delegatedRoleDefinitionIds: Output<List<String>>? = null

    private var principalId: Output<String>? = null

    private var principalIdDisplayName: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    /**
     * @param value The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role. It is the list of role definition ids which define all the permissions that the user in the authorization can assign to other principals.
     */
    @JvmName("eavubudwwwceswjg")
    public suspend fun delegatedRoleDefinitionIds(`value`: Output<List<String>>) {
        this.delegatedRoleDefinitionIds = value
    }

    @JvmName("sdhqrlyubpmjixsh")
    public suspend fun delegatedRoleDefinitionIds(vararg values: Output<String>) {
        this.delegatedRoleDefinitionIds = Output.all(values.asList())
    }

    /**
     * @param values The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role. It is the list of role definition ids which define all the permissions that the user in the authorization can assign to other principals.
     */
    @JvmName("nqfumkroqshcrwjf")
    public suspend fun delegatedRoleDefinitionIds(values: List<Output<String>>) {
        this.delegatedRoleDefinitionIds = Output.all(values)
    }

    /**
     * @param value The identifier of the Azure Active Directory principal.
     */
    @JvmName("jjsfvkyedtsjvndh")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The display name of the Azure Active Directory principal.
     */
    @JvmName("cffpgcjgljarbnnl")
    public suspend fun principalIdDisplayName(`value`: Output<String>) {
        this.principalIdDisplayName = value
    }

    /**
     * @param value The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
     */
    @JvmName("oundnokieoxabbaj")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role. It is the list of role definition ids which define all the permissions that the user in the authorization can assign to other principals.
     */
    @JvmName("tkjaoanctmoskedf")
    public suspend fun delegatedRoleDefinitionIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegatedRoleDefinitionIds = mapped
    }

    /**
     * @param values The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role. It is the list of role definition ids which define all the permissions that the user in the authorization can assign to other principals.
     */
    @JvmName("aamptbgjgtbgaumk")
    public suspend fun delegatedRoleDefinitionIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.delegatedRoleDefinitionIds = mapped
    }

    /**
     * @param value The identifier of the Azure Active Directory principal.
     */
    @JvmName("pjlylwjdvyxtsova")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The display name of the Azure Active Directory principal.
     */
    @JvmName("vnhmhouqmuxvayfu")
    public suspend fun principalIdDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalIdDisplayName = mapped
    }

    /**
     * @param value The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
     */
    @JvmName("kwyqchvhkchrthab")
    public suspend fun roleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    internal fun build(): AuthorizationArgs = AuthorizationArgs(
        delegatedRoleDefinitionIds = delegatedRoleDefinitionIds,
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        principalIdDisplayName = principalIdDisplayName,
        roleDefinitionId = roleDefinitionId ?: throw PulumiNullFieldException("roleDefinitionId"),
    )
}
