@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.RegistrationAssignmentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the registration assignment.
 * @property registrationDefinitionId The fully qualified path of the registration definition.
 */
public data class RegistrationAssignmentPropertiesArgs(
    public val registrationDefinitionId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.RegistrationAssignmentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managedservices.inputs.RegistrationAssignmentPropertiesArgs =
        com.pulumi.azurenative.managedservices.inputs.RegistrationAssignmentPropertiesArgs.builder()
            .registrationDefinitionId(registrationDefinitionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistrationAssignmentPropertiesArgs].
 */
@PulumiTagMarker
public class RegistrationAssignmentPropertiesArgsBuilder internal constructor() {
    private var registrationDefinitionId: Output<String>? = null

    /**
     * @param value The fully qualified path of the registration definition.
     */
    @JvmName("maefuwgwwvasakfb")
    public suspend fun registrationDefinitionId(`value`: Output<String>) {
        this.registrationDefinitionId = value
    }

    /**
     * @param value The fully qualified path of the registration definition.
     */
    @JvmName("txbjqriddtnoikje")
    public suspend fun registrationDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registrationDefinitionId = mapped
    }

    internal fun build(): RegistrationAssignmentPropertiesArgs = RegistrationAssignmentPropertiesArgs(
        registrationDefinitionId = registrationDefinitionId ?: throw
            PulumiNullFieldException("registrationDefinitionId"),
    )
}
