@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Azure Active Directory principal identifier, Azure built-in role, and just-in-time access policy that describes the just-in-time access the principal will receive on the delegated resource in the managed tenant.
 * @property justInTimeAccessPolicy The just-in-time access policy setting.
 * @property principalId The identifier of the Azure Active Directory principal.
 * @property principalIdDisplayName The display name of the Azure Active Directory principal.
 * @property roleDefinitionId The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
 */
public data class EligibleAuthorizationResponse(
    public val justInTimeAccessPolicy: JustInTimeAccessPolicyResponse? = null,
    public val principalId: String,
    public val principalIdDisplayName: String? = null,
    public val roleDefinitionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.EligibleAuthorizationResponse): EligibleAuthorizationResponse = EligibleAuthorizationResponse(
            justInTimeAccessPolicy = javaType.justInTimeAccessPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managedservices.kotlin.outputs.JustInTimeAccessPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            principalId = javaType.principalId(),
            principalIdDisplayName = javaType.principalIdDisplayName().map({ args0 -> args0 }).orElse(null),
            roleDefinitionId = javaType.roleDefinitionId(),
        )
    }
}
