@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Just-in-time access policy setting.
 * @property managedByTenantApprovers The list of managedByTenant approvers for the eligible authorization.
 * @property maximumActivationDuration The maximum access duration in ISO 8601 format for just-in-time access requests.
 * @property multiFactorAuthProvider The multi-factor authorization provider to be used for just-in-time access requests.
 */
public data class JustInTimeAccessPolicyResponse(
    public val managedByTenantApprovers: List<EligibleApproverResponse>? = null,
    public val maximumActivationDuration: String? = null,
    public val multiFactorAuthProvider: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.JustInTimeAccessPolicyResponse): JustInTimeAccessPolicyResponse = JustInTimeAccessPolicyResponse(
            managedByTenantApprovers = javaType.managedByTenantApprovers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managedservices.kotlin.outputs.EligibleApproverResponse.Companion.toKotlin(args0)
                })
            }),
            maximumActivationDuration = javaType.maximumActivationDuration().map({ args0 ->
                args0
            }).orElse(null),
            multiFactorAuthProvider = javaType.multiFactorAuthProvider(),
        )
    }
}
