@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details for the Managed Services offer’s plan in Azure Marketplace.
 * @property name Azure Marketplace plan name.
 * @property product Azure Marketplace product code.
 * @property publisher Azure Marketplace publisher ID.
 * @property version Azure Marketplace plan's version.
 */
public data class PlanResponse(
    public val name: String,
    public val product: String,
    public val publisher: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.PlanResponse): PlanResponse = PlanResponse(
            name = javaType.name(),
            product = javaType.product(),
            publisher = javaType.publisher(),
            version = javaType.version(),
        )
    }
}
