@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the registration assignment.
 * @property provisioningState The current provisioning state of the registration assignment.
 * @property registrationDefinition The registration definition associated with the registration assignment.
 * @property registrationDefinitionId The fully qualified path of the registration definition.
 */
public data class RegistrationAssignmentPropertiesResponse(
    public val provisioningState: String,
    public val registrationDefinition: RegistrationAssignmentPropertiesResponseRegistrationDefinition,
    public val registrationDefinitionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.RegistrationAssignmentPropertiesResponse): RegistrationAssignmentPropertiesResponse = RegistrationAssignmentPropertiesResponse(
            provisioningState = javaType.provisioningState(),
            registrationDefinition = javaType.registrationDefinition().let({ args0 ->
                com.pulumi.azurenative.managedservices.kotlin.outputs.RegistrationAssignmentPropertiesResponseRegistrationDefinition.Companion.toKotlin(args0)
            }),
            registrationDefinitionId = javaType.registrationDefinitionId(),
        )
    }
}
