@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the registration definition associated with the registration assignment.
 * @property authorizations The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
 * @property description The description of the registration definition.
 * @property eligibleAuthorizations The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
 * @property managedByTenantId The identifier of the managedBy tenant.
 * @property managedByTenantName The name of the managedBy tenant.
 * @property manageeTenantId The identifier of the managed tenant.
 * @property manageeTenantName The name of the managed tenant.
 * @property provisioningState The current provisioning state of the registration definition.
 * @property registrationDefinitionName The name of the registration definition.
 */
public data class RegistrationAssignmentPropertiesResponseProperties(
    public val authorizations: List<AuthorizationResponse>? = null,
    public val description: String? = null,
    public val eligibleAuthorizations: List<EligibleAuthorizationResponse>? = null,
    public val managedByTenantId: String? = null,
    public val managedByTenantName: String? = null,
    public val manageeTenantId: String? = null,
    public val manageeTenantName: String? = null,
    public val provisioningState: String? = null,
    public val registrationDefinitionName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.RegistrationAssignmentPropertiesResponseProperties): RegistrationAssignmentPropertiesResponseProperties =
            RegistrationAssignmentPropertiesResponseProperties(
                authorizations = javaType.authorizations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.managedservices.kotlin.outputs.AuthorizationResponse.Companion.toKotlin(args0)
                    })
                }),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                eligibleAuthorizations = javaType.eligibleAuthorizations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.managedservices.kotlin.outputs.EligibleAuthorizationResponse.Companion.toKotlin(args0)
                    })
                }),
                managedByTenantId = javaType.managedByTenantId().map({ args0 -> args0 }).orElse(null),
                managedByTenantName = javaType.managedByTenantName().map({ args0 -> args0 }).orElse(null),
                manageeTenantId = javaType.manageeTenantId().map({ args0 -> args0 }).orElse(null),
                manageeTenantName = javaType.manageeTenantName().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
                registrationDefinitionName = javaType.registrationDefinitionName().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
