@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin

import com.pulumi.azurenative.management.ManagementGroupSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The details of subscription under management group.
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2023-04-01.
 * ## Example Usage
 * ### AddSubscriptionToManagementGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroupSubscription = new AzureNative.Management.ManagementGroupSubscription("managementGroupSubscription", new()
 *     {
 *         GroupId = "Group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/management/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := management.NewManagementGroupSubscription(ctx, "managementGroupSubscription", &management.ManagementGroupSubscriptionArgs{
 * 			GroupId: pulumi.String("Group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.management.ManagementGroupSubscription;
 * import com.pulumi.azurenative.management.ManagementGroupSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroupSubscription = new ManagementGroupSubscription("managementGroupSubscription", ManagementGroupSubscriptionArgs.builder()
 *             .groupId("Group")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:management:ManagementGroupSubscription 728bcbe4-8d56-4510-86c2-4921b8beefbc /providers/Microsoft.Management/managementGroups/{groupId}/subscriptions/{subscriptionId}
 * ```
 * @property groupId Management Group ID.
 * @property subscriptionId Subscription ID.
 */
public data class ManagementGroupSubscriptionArgs(
    public val groupId: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.management.ManagementGroupSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.management.ManagementGroupSubscriptionArgs =
        com.pulumi.azurenative.management.ManagementGroupSubscriptionArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementGroupSubscriptionArgs].
 */
@PulumiTagMarker
public class ManagementGroupSubscriptionArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value Management Group ID.
     */
    @JvmName("stejmorbneyasgln")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Subscription ID.
     */
    @JvmName("epwddrdjsjtvvxty")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Management Group ID.
     */
    @JvmName("loehwmixksmrjakb")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Subscription ID.
     */
    @JvmName("jdcfwnlxorsujxhf")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): ManagementGroupSubscriptionArgs = ManagementGroupSubscriptionArgs(
        groupId = groupId,
        subscriptionId = subscriptionId,
    )
}
