@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The ID of the parent management group.
 * @property id The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
 */
public data class DescendantParentGroupInfoResponse(
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.DescendantParentGroupInfoResponse): DescendantParentGroupInfoResponse = DescendantParentGroupInfoResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
