@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the result of the request to view entities.
 * @property count Total count of records that match the filter
 * @property nextLink The URL to use for getting the next set of results.
 * @property value The list of entities.
 */
public data class GetEntityResult(
    public val count: Int,
    public val nextLink: String,
    public val `value`: List<EntityInfoResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.GetEntityResult): GetEntityResult = GetEntityResult(
            count = javaType.count(),
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.EntityInfoResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
