@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Settings defined at the Management Group scope.
 * @property defaultManagementGroup Settings that sets the default Management Group under which new subscriptions get added in this tenant. For example, /providers/Microsoft.Management/managementGroups/defaultGroup
 * @property id The fully qualified ID for the settings object.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000/settings/default.
 * @property name The name of the object. In this case, default.
 * @property requireAuthorizationForGroupCreation Indicates whether RBAC access is required upon group creation under the root Management Group. If set to true, user will require Microsoft.Management/managementGroups/write action on the root Management Group scope in order to create new Groups directly under the root. This will prevent new users from creating new Management Groups, unless they are given access.
 * @property tenantId The AAD Tenant ID associated with the hierarchy settings. For example, 00000000-0000-0000-0000-000000000000
 * @property type The type of the resource.  For example, Microsoft.Management/managementGroups/settings.
 */
public data class GetHierarchySettingResult(
    public val defaultManagementGroup: String? = null,
    public val id: String,
    public val name: String,
    public val requireAuthorizationForGroupCreation: Boolean? = null,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.GetHierarchySettingResult): GetHierarchySettingResult = GetHierarchySettingResult(
            defaultManagementGroup = javaType.defaultManagementGroup().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            requireAuthorizationForGroupCreation = javaType.requireAuthorizationForGroupCreation().map({ args0 ->
                args0
            }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
