@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of subscription under management group.
 * @property displayName The friendly name of the subscription.
 * @property id The fully qualified ID for the subscription.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000/subscriptions/0000000-0000-0000-0000-000000000001
 * @property name The stringified id of the subscription. For example, 00000000-0000-0000-0000-000000000000
 * @property parent The ID of the parent management group.
 * @property state The state of the subscription.
 * @property tenant The AAD Tenant ID associated with the subscription. For example, 00000000-0000-0000-0000-000000000000
 * @property type The type of the resource.  For example, Microsoft.Management/managementGroups/subscriptions
 */
public data class GetManagementGroupSubscriptionResult(
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val parent: DescendantParentGroupInfoResponse? = null,
    public val state: String? = null,
    public val tenant: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.GetManagementGroupSubscriptionResult): GetManagementGroupSubscriptionResult = GetManagementGroupSubscriptionResult(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            parent = javaType.parent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.DescendantParentGroupInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
