@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The details of a management group.
 * @property managementGroupAncestors The ancestors of the management group.
 * @property managementGroupAncestorsChain The ancestors of the management group displayed in reversed order, from immediate parent to the root.
 * @property parent (Optional) The ID of the parent management group.
 * @property path The path from the root to the current group.
 * @property updatedBy The identity of the principal or process that updated the object.
 * @property updatedTime The date and time when this object was last updated.
 * @property version The version number of the object.
 */
public data class ManagementGroupDetailsResponse(
    public val managementGroupAncestors: List<String>? = null,
    public val managementGroupAncestorsChain: List<ManagementGroupPathElementResponse>? = null,
    public val parent: ParentGroupInfoResponse? = null,
    public val path: List<ManagementGroupPathElementResponse>? = null,
    public val updatedBy: String? = null,
    public val updatedTime: String? = null,
    public val version: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.ManagementGroupDetailsResponse): ManagementGroupDetailsResponse = ManagementGroupDetailsResponse(
            managementGroupAncestors = javaType.managementGroupAncestors().map({ args0 -> args0 }),
            managementGroupAncestorsChain = javaType.managementGroupAncestorsChain().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupPathElementResponse.Companion.toKotlin(args0)
                })
            }),
            parent = javaType.parent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.ParentGroupInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            path = javaType.path().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupPathElementResponse.Companion.toKotlin(args0)
                })
            }),
            updatedBy = javaType.updatedBy().map({ args0 -> args0 }).orElse(null),
            updatedTime = javaType.updatedTime().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
