@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A path element of a management group ancestors.
 * @property displayName The friendly name of the group.
 * @property name The name of the group.
 */
public data class ManagementGroupPathElementResponse(
    public val displayName: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.ManagementGroupPathElementResponse): ManagementGroupPathElementResponse = ManagementGroupPathElementResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
