@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managementpartner.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Partner].
 */
@PulumiTagMarker
public class PartnerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartnerArgs = PartnerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartnerArgsBuilder.() -> Unit) {
        val builder = PartnerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Partner {
        val builtJavaResource =
            com.pulumi.azurenative.managementpartner.Partner(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Partner(builtJavaResource)
    }
}

/**
 * this is the management partner operations response
 * Azure REST API version: 2018-02-01. Prior API version in Azure Native 1.x: 2018-02-01.
 * ## Example Usage
 * ### PutPartnerDetails
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partner = new AzureNative.ManagementPartner.Partner("partner", new()
 *     {
 *         PartnerId = "123456",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managementpartner/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managementpartner.NewPartner(ctx, "partner", &managementpartner.PartnerArgs{
 * 			PartnerId: pulumi.String("123456"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managementpartner.Partner;
 * import com.pulumi.azurenative.managementpartner.PartnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partner = new Partner("partner", PartnerArgs.builder()
 *             .partnerId("123456")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managementpartner:Partner 123456 /providers/Microsoft.ManagementPartner/partners/{partnerId}
 * ```
 */
public class Partner internal constructor(
    override val javaResource: com.pulumi.azurenative.managementpartner.Partner,
) : KotlinCustomResource(javaResource, PartnerMapper) {
    /**
     * This is the DateTime when the partner was created.
     */
    public val createdTime: Output<String>?
        get() = javaResource.createdTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the partner
     */
    public val etag: Output<Int>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the partner
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * This is the object id.
     */
    public val objectId: Output<String>?
        get() = javaResource.objectId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This is the partner id
     */
    public val partnerId: Output<String>?
        get() = javaResource.partnerId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This is the partner name
     */
    public val partnerName: Output<String>?
        get() = javaResource.partnerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is the tenant id.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of resource. "Microsoft.ManagementPartner/partners"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * This is the DateTime when the partner was updated.
     */
    public val updatedTime: Output<String>?
        get() = javaResource.updatedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is the version.
     */
    public val version: Output<Int>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object PartnerMapper : ResourceMapper<Partner> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managementpartner.Partner::class == javaResource::class

    override fun map(javaResource: Resource): Partner = Partner(
        javaResource as
            com.pulumi.azurenative.managementpartner.Partner,
    )
}

/**
 * @see [Partner].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Partner].
 */
public suspend fun partner(name: String, block: suspend PartnerResourceBuilder.() -> Unit): Partner {
    val builder = PartnerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Partner].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partner(name: String): Partner {
    val builder = PartnerResourceBuilder()
    builder.name(name)
    return builder.build()
}
