@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managementpartner.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * this is the management partner operations response
 * @property createdTime This is the DateTime when the partner was created.
 * @property etag Type of the partner
 * @property id Identifier of the partner
 * @property name Name of the partner
 * @property objectId This is the object id.
 * @property partnerId This is the partner id
 * @property partnerName This is the partner name
 * @property tenantId This is the tenant id.
 * @property type Type of resource. "Microsoft.ManagementPartner/partners"
 * @property updatedTime This is the DateTime when the partner was updated.
 * @property version This is the version.
 */
public data class GetPartnerResult(
    public val createdTime: String? = null,
    public val etag: Int? = null,
    public val id: String,
    public val name: String,
    public val objectId: String? = null,
    public val partnerId: String? = null,
    public val partnerName: String? = null,
    public val tenantId: String? = null,
    public val type: String,
    public val updatedTime: String? = null,
    public val version: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managementpartner.outputs.GetPartnerResult): GetPartnerResult = GetPartnerResult(
            createdTime = javaType.createdTime().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            partnerId = javaType.partnerId().map({ args0 -> args0 }).orElse(null),
            partnerName = javaType.partnerName().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updatedTime = javaType.updatedTime().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
