@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin

import com.pulumi.azurenative.maps.CreatorArgs.builder
import com.pulumi.azurenative.maps.kotlin.inputs.CreatorPropertiesArgs
import com.pulumi.azurenative.maps.kotlin.inputs.CreatorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure resource which represents Maps Creator product and provides ability to manage private location data.
 * Azure REST API version: 2021-02-01. Prior API version in Azure Native 1.x: 2020-02-01-preview.
 * Other available API versions: 2020-02-01-preview, 2021-12-01-preview, 2023-06-01, 2023-08-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Create Creator Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var creator = new AzureNative.Maps.Creator("creator", new()
 *     {
 *         AccountName = "myMapsAccount",
 *         CreatorName = "myCreator",
 *         Location = "eastus2",
 *         Properties = new AzureNative.Maps.Inputs.CreatorPropertiesArgs
 *         {
 *             StorageUnits = 5,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "test", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maps/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maps.NewCreator(ctx, "creator", &maps.CreatorArgs{
 * 			AccountName: pulumi.String("myMapsAccount"),
 * 			CreatorName: pulumi.String("myCreator"),
 * 			Location:    pulumi.String("eastus2"),
 * 			Properties: &maps.CreatorPropertiesArgs{
 * 				StorageUnits: pulumi.Int(5),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"test": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maps.Creator;
 * import com.pulumi.azurenative.maps.CreatorArgs;
 * import com.pulumi.azurenative.maps.inputs.CreatorPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var creator = new Creator("creator", CreatorArgs.builder()
 *             .accountName("myMapsAccount")
 *             .creatorName("myCreator")
 *             .location("eastus2")
 *             .properties(CreatorPropertiesArgs.builder()
 *                 .storageUnits(5)
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("test", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maps:Creator myCreator /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}/creators/{creatorName}
 * ```
 * @property accountName The name of the Maps Account.
 * @property creatorName The name of the Maps Creator instance.
 * @property location The geo-location where the resource lives
 * @property properties The Creator resource properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class CreatorArgs(
    public val accountName: Output<String>? = null,
    public val creatorName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<CreatorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maps.CreatorArgs> {
    override fun toJava(): com.pulumi.azurenative.maps.CreatorArgs =
        com.pulumi.azurenative.maps.CreatorArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .creatorName(creatorName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CreatorArgs].
 */
@PulumiTagMarker
public class CreatorArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var creatorName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<CreatorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Maps Account.
     */
    @JvmName("txtnxaqvkpumsdef")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the Maps Creator instance.
     */
    @JvmName("pgxqhovfqjpvtvkf")
    public suspend fun creatorName(`value`: Output<String>) {
        this.creatorName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jbqatbbawpijwpch")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The Creator resource properties.
     */
    @JvmName("ntnmbehdpytjrhmk")
    public suspend fun properties(`value`: Output<CreatorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mvsmbrcooiffudvx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mpvggtxmjandmnmc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Maps Account.
     */
    @JvmName("lypsyhmvgopkdwcs")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Maps Creator instance.
     */
    @JvmName("htsmngtnwrdfrmhd")
    public suspend fun creatorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creatorName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mvxijocjwnubwnec")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The Creator resource properties.
     */
    @JvmName("wjshfrlwcobnobkk")
    public suspend fun properties(`value`: CreatorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The Creator resource properties.
     */
    @JvmName("htxofhciqpcmlmfh")
    public suspend fun properties(argument: suspend CreatorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CreatorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yenkklhjcxwykpbq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vglivjnhmjrfmgte")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("pivlrdhulbbqxhlb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CreatorArgs = CreatorArgs(
        accountName = accountName,
        creatorName = creatorName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
