@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The name of the SKU, in standard format (such as S0).
 */
public enum class Name(
    public val javaValue: com.pulumi.azurenative.maps.enums.Name,
) : ConvertibleToJava<com.pulumi.azurenative.maps.enums.Name> {
    S0(com.pulumi.azurenative.maps.enums.Name.S0),
    S1(com.pulumi.azurenative.maps.enums.Name.S1),
    G2(com.pulumi.azurenative.maps.enums.Name.G2),
    ;

    override fun toJava(): com.pulumi.azurenative.maps.enums.Name = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maps.enums.Name): Name =
            Name.values().first { it.javaValue == javaType }
    }
}
