@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Creator resource properties
 * @property provisioningState The state of the resource provisioning, terminal states: Succeeded, Failed, Canceled
 * @property storageUnits The storage units to be allocated. Integer values from 1 to 100, inclusive.
 */
public data class CreatorPropertiesResponse(
    public val provisioningState: String,
    public val storageUnits: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maps.outputs.CreatorPropertiesResponse): CreatorPropertiesResponse = CreatorPropertiesResponse(
            provisioningState = javaType.provisioningState(),
            storageUnits = javaType.storageUnits(),
        )
    }
}
