@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Additional Map account properties
 * @property disableLocalAuth Allows toggle functionality on Azure Policy to disable Azure Maps local authentication support. This will disable Shared Keys authentication from any usage.
 * @property provisioningState the state of the provisioning.
 * @property uniqueId A unique identifier for the maps account
 */
public data class MapsAccountPropertiesResponse(
    public val disableLocalAuth: Boolean? = null,
    public val provisioningState: String,
    public val uniqueId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maps.outputs.MapsAccountPropertiesResponse): MapsAccountPropertiesResponse = MapsAccountPropertiesResponse(
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            uniqueId = javaType.uniqueId(),
        )
    }
}
