@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private Atlas resource properties
 * @property provisioningState The state of the resource provisioning, terminal states: Succeeded, Failed, Canceled
 */
public data class PrivateAtlasPropertiesResponse(
    public val provisioningState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maps.outputs.PrivateAtlasPropertiesResponse): PrivateAtlasPropertiesResponse = PrivateAtlasPropertiesResponse(
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
