@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SKU of the Maps Account.
 * @property name The name of the SKU, in standard format (such as S0).
 * @property tier Gets the sku tier. This is based on the SKU name.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maps.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                name = javaType.name(),
                tier = javaType.tier(),
            )
    }
}
