@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin

import com.pulumi.azurenative.marketplace.MarketplaceFunctions.getPrivateStoreCollectionOfferPlain
import com.pulumi.azurenative.marketplace.MarketplaceFunctions.getPrivateStoreCollectionPlain
import com.pulumi.azurenative.marketplace.MarketplaceFunctions.listPrivateStoreNewPlansNotificationsPlain
import com.pulumi.azurenative.marketplace.MarketplaceFunctions.listPrivateStoreStopSellOffersPlansNotificationsPlain
import com.pulumi.azurenative.marketplace.MarketplaceFunctions.listPrivateStoreSubscriptionsContextPlain
import com.pulumi.azurenative.marketplace.kotlin.inputs.GetPrivateStoreCollectionOfferPlainArgs
import com.pulumi.azurenative.marketplace.kotlin.inputs.GetPrivateStoreCollectionOfferPlainArgsBuilder
import com.pulumi.azurenative.marketplace.kotlin.inputs.GetPrivateStoreCollectionPlainArgs
import com.pulumi.azurenative.marketplace.kotlin.inputs.GetPrivateStoreCollectionPlainArgsBuilder
import com.pulumi.azurenative.marketplace.kotlin.inputs.ListPrivateStoreNewPlansNotificationsPlainArgs
import com.pulumi.azurenative.marketplace.kotlin.inputs.ListPrivateStoreNewPlansNotificationsPlainArgsBuilder
import com.pulumi.azurenative.marketplace.kotlin.inputs.ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs
import com.pulumi.azurenative.marketplace.kotlin.inputs.ListPrivateStoreStopSellOffersPlansNotificationsPlainArgsBuilder
import com.pulumi.azurenative.marketplace.kotlin.inputs.ListPrivateStoreSubscriptionsContextPlainArgs
import com.pulumi.azurenative.marketplace.kotlin.inputs.ListPrivateStoreSubscriptionsContextPlainArgsBuilder
import com.pulumi.azurenative.marketplace.kotlin.outputs.GetPrivateStoreCollectionOfferResult
import com.pulumi.azurenative.marketplace.kotlin.outputs.GetPrivateStoreCollectionResult
import com.pulumi.azurenative.marketplace.kotlin.outputs.ListPrivateStoreNewPlansNotificationsResult
import com.pulumi.azurenative.marketplace.kotlin.outputs.ListPrivateStoreStopSellOffersPlansNotificationsResult
import com.pulumi.azurenative.marketplace.kotlin.outputs.ListPrivateStoreSubscriptionsContextResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.marketplace.kotlin.outputs.GetPrivateStoreCollectionOfferResult.Companion.toKotlin as getPrivateStoreCollectionOfferResultToKotlin
import com.pulumi.azurenative.marketplace.kotlin.outputs.GetPrivateStoreCollectionResult.Companion.toKotlin as getPrivateStoreCollectionResultToKotlin
import com.pulumi.azurenative.marketplace.kotlin.outputs.ListPrivateStoreNewPlansNotificationsResult.Companion.toKotlin as listPrivateStoreNewPlansNotificationsResultToKotlin
import com.pulumi.azurenative.marketplace.kotlin.outputs.ListPrivateStoreStopSellOffersPlansNotificationsResult.Companion.toKotlin as listPrivateStoreStopSellOffersPlansNotificationsResultToKotlin
import com.pulumi.azurenative.marketplace.kotlin.outputs.ListPrivateStoreSubscriptionsContextResult.Companion.toKotlin as listPrivateStoreSubscriptionsContextResultToKotlin

public object MarketplaceFunctions {
    /**
     * Gets private store collection
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return The Collection data structure.
     */
    public suspend fun getPrivateStoreCollection(argument: GetPrivateStoreCollectionPlainArgs): GetPrivateStoreCollectionResult =
        getPrivateStoreCollectionResultToKotlin(getPrivateStoreCollectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateStoreCollection].
     * @param collectionId The collection ID
     * @param privateStoreId The store ID - must use the tenant ID
     * @return The Collection data structure.
     */
    public suspend fun getPrivateStoreCollection(collectionId: String, privateStoreId: String): GetPrivateStoreCollectionResult {
        val argument = GetPrivateStoreCollectionPlainArgs(
            collectionId = collectionId,
            privateStoreId = privateStoreId,
        )
        return getPrivateStoreCollectionResultToKotlin(getPrivateStoreCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateStoreCollection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;marketplace&#46;kotlin&#46;inputs&#46;GetPrivateStoreCollectionPlainArgs].
     * @return The Collection data structure.
     */
    public suspend fun getPrivateStoreCollection(argument: suspend GetPrivateStoreCollectionPlainArgsBuilder.() -> Unit): GetPrivateStoreCollectionResult {
        val builder = GetPrivateStoreCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateStoreCollectionResultToKotlin(getPrivateStoreCollectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a specific offer.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return The privateStore offer data structure.
     */
    public suspend fun getPrivateStoreCollectionOffer(argument: GetPrivateStoreCollectionOfferPlainArgs): GetPrivateStoreCollectionOfferResult =
        getPrivateStoreCollectionOfferResultToKotlin(getPrivateStoreCollectionOfferPlain(argument.toJava()).await())

    /**
     * @see [getPrivateStoreCollectionOffer].
     * @param collectionId The collection ID
     * @param offerId The offer ID to update or delete
     * @param privateStoreId The store ID - must use the tenant ID
     * @return The privateStore offer data structure.
     */
    public suspend fun getPrivateStoreCollectionOffer(
        collectionId: String,
        offerId: String,
        privateStoreId: String,
    ): GetPrivateStoreCollectionOfferResult {
        val argument = GetPrivateStoreCollectionOfferPlainArgs(
            collectionId = collectionId,
            offerId = offerId,
            privateStoreId = privateStoreId,
        )
        return getPrivateStoreCollectionOfferResultToKotlin(getPrivateStoreCollectionOfferPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateStoreCollectionOffer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;marketplace&#46;kotlin&#46;inputs&#46;GetPrivateStoreCollectionOfferPlainArgs].
     * @return The privateStore offer data structure.
     */
    public suspend fun getPrivateStoreCollectionOffer(argument: suspend GetPrivateStoreCollectionOfferPlainArgsBuilder.() -> Unit): GetPrivateStoreCollectionOfferResult {
        val builder = GetPrivateStoreCollectionOfferPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateStoreCollectionOfferResultToKotlin(getPrivateStoreCollectionOfferPlain(builtArgument.toJava()).await())
    }

    /**
     * List new plans notifications
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2021-12-01, 2022-03-01, 2022-09-01.
     * @param argument null
     * @return List of all new plans notifications for public offers
     */
    public suspend fun listPrivateStoreNewPlansNotifications(argument: ListPrivateStoreNewPlansNotificationsPlainArgs): ListPrivateStoreNewPlansNotificationsResult =
        listPrivateStoreNewPlansNotificationsResultToKotlin(listPrivateStoreNewPlansNotificationsPlain(argument.toJava()).await())

    /**
     * @see [listPrivateStoreNewPlansNotifications].
     * @param privateStoreId The store ID - must use the tenant ID
     * @return List of all new plans notifications for public offers
     */
    public suspend fun listPrivateStoreNewPlansNotifications(privateStoreId: String): ListPrivateStoreNewPlansNotificationsResult {
        val argument = ListPrivateStoreNewPlansNotificationsPlainArgs(
            privateStoreId = privateStoreId,
        )
        return listPrivateStoreNewPlansNotificationsResultToKotlin(listPrivateStoreNewPlansNotificationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listPrivateStoreNewPlansNotifications].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;marketplace&#46;kotlin&#46;inputs&#46;ListPrivateStoreNewPlansNotificationsPlainArgs].
     * @return List of all new plans notifications for public offers
     */
    public suspend fun listPrivateStoreNewPlansNotifications(argument: suspend ListPrivateStoreNewPlansNotificationsPlainArgsBuilder.() -> Unit): ListPrivateStoreNewPlansNotificationsResult {
        val builder = ListPrivateStoreNewPlansNotificationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listPrivateStoreNewPlansNotificationsResultToKotlin(listPrivateStoreNewPlansNotificationsPlain(builtArgument.toJava()).await())
    }

    /**
     * List stop sell notifications for both stop sell offers and stop sell plans
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2021-12-01, 2022-03-01, 2022-09-01.
     * @param argument null
     * @return List of stop sell offers and plans notifications.
     */
    public suspend fun listPrivateStoreStopSellOffersPlansNotifications(argument: ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs): ListPrivateStoreStopSellOffersPlansNotificationsResult =
        listPrivateStoreStopSellOffersPlansNotificationsResultToKotlin(listPrivateStoreStopSellOffersPlansNotificationsPlain(argument.toJava()).await())

    /**
     * @see [listPrivateStoreStopSellOffersPlansNotifications].
     * @param privateStoreId The store ID - must use the tenant ID
     * @param subscriptions
     * @return List of stop sell offers and plans notifications.
     */
    public suspend fun listPrivateStoreStopSellOffersPlansNotifications(
        privateStoreId: String,
        subscriptions: List<String>? = null,
    ): ListPrivateStoreStopSellOffersPlansNotificationsResult {
        val argument = ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs(
            privateStoreId = privateStoreId,
            subscriptions = subscriptions,
        )
        return listPrivateStoreStopSellOffersPlansNotificationsResultToKotlin(listPrivateStoreStopSellOffersPlansNotificationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listPrivateStoreStopSellOffersPlansNotifications].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;marketplace&#46;kotlin&#46;inputs&#46;ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs].
     * @return List of stop sell offers and plans notifications.
     */
    public suspend fun listPrivateStoreStopSellOffersPlansNotifications(argument: suspend ListPrivateStoreStopSellOffersPlansNotificationsPlainArgsBuilder.() -> Unit): ListPrivateStoreStopSellOffersPlansNotificationsResult {
        val builder = ListPrivateStoreStopSellOffersPlansNotificationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listPrivateStoreStopSellOffersPlansNotificationsResultToKotlin(listPrivateStoreStopSellOffersPlansNotificationsPlain(builtArgument.toJava()).await())
    }

    /**
     * List all the subscriptions in the private store context
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2021-12-01, 2022-03-01, 2022-09-01.
     * @param argument null
     * @return List of subscription Ids in the private store
     */
    public suspend fun listPrivateStoreSubscriptionsContext(argument: ListPrivateStoreSubscriptionsContextPlainArgs): ListPrivateStoreSubscriptionsContextResult =
        listPrivateStoreSubscriptionsContextResultToKotlin(listPrivateStoreSubscriptionsContextPlain(argument.toJava()).await())

    /**
     * @see [listPrivateStoreSubscriptionsContext].
     * @param privateStoreId The store ID - must use the tenant ID
     * @return List of subscription Ids in the private store
     */
    public suspend fun listPrivateStoreSubscriptionsContext(privateStoreId: String): ListPrivateStoreSubscriptionsContextResult {
        val argument = ListPrivateStoreSubscriptionsContextPlainArgs(
            privateStoreId = privateStoreId,
        )
        return listPrivateStoreSubscriptionsContextResultToKotlin(listPrivateStoreSubscriptionsContextPlain(argument.toJava()).await())
    }

    /**
     * @see [listPrivateStoreSubscriptionsContext].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;marketplace&#46;kotlin&#46;inputs&#46;ListPrivateStoreSubscriptionsContextPlainArgs].
     * @return List of subscription Ids in the private store
     */
    public suspend fun listPrivateStoreSubscriptionsContext(argument: suspend ListPrivateStoreSubscriptionsContextPlainArgsBuilder.() -> Unit): ListPrivateStoreSubscriptionsContextResult {
        val builder = ListPrivateStoreSubscriptionsContextPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listPrivateStoreSubscriptionsContextResultToKotlin(listPrivateStoreSubscriptionsContextPlain(builtArgument.toJava()).await())
    }
}
